/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.crafting;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.craftingtweaks.crafting.CraftingOperation;
import net.blay09.mods.craftingtweaks.crafting.IngredientCacheHint;
import net.blay09.mods.craftingtweaks.crafting.IngredientProvider;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_8786;

public class CraftingContext {
    private final Map<IntList, Integer> cachedProviderIndexByIngredient = new HashMap<IntList, Integer>();
    private final Map<CraftingOperation.IngredientTokenKey, IngredientCacheHint> cacheHintsByIngredient = new HashMap<CraftingOperation.IngredientTokenKey, IngredientCacheHint>();
    private final List<IngredientProvider> ingredientProviders;

    public CraftingContext(List<IngredientProvider> ingredientProviders) {
        this.ingredientProviders = ingredientProviders;
    }

    public CraftingOperation createOperation(class_8786<class_1860<?>> recipe) {
        return new CraftingOperation(this, recipe);
    }

    public List<IngredientProvider> getIngredientProviders() {
        return this.ingredientProviders;
    }

    public int getCachedIngredientProviderIndexFor(class_1856 ingredient) {
        return this.cachedProviderIndexByIngredient.getOrDefault(ingredient.method_8100(), -1);
    }

    public IngredientCacheHint getCacheHintFor(CraftingOperation.IngredientTokenKey ingredientTokenKey) {
        return this.cacheHintsByIngredient.getOrDefault(ingredientTokenKey, IngredientCacheHint.NONE);
    }

    public void cache(CraftingOperation.IngredientTokenKey ingredientTokenKey, int itemProviderIndex, IngredientCacheHint cacheHint) {
        this.cacheHintsByIngredient.put(ingredientTokenKey, cacheHint);
        this.cachedProviderIndexByIngredient.put(ingredientTokenKey.stackingIds(), itemProviderIndex);
    }
}

